#include <BWAPI.h>
#include <math.h>
#include "../Addons/Util.h"
#include <UnitGroupManager.h>


#pragma once
using namespace BWAPI;
using namespace std;

const int size = 5;

class ZerglingManager
{
public:
	     // Global Variables
		 // Red Home = 31, 7
		 // Blue Home = 66, 119
		 Unit *enemy;
		 
		 int groupSize;
		 int zergHP;

		 bool findPosition;

		 int counter;

		 bool grab;
		 bool groupPhase;
		 bool zergAttack;
		 bool groupGather;
		 bool groupAttack;

		 Position firstGroupCoord[size];
		 Position secondGroupCoord[size];
		 Position blah;


		 UnitGroup GroupZerg;
		 UnitGroup groupOne;
		 UnitGroup groupTwo;

	    ~ZerglingManager(void)
        {
		}
		void onFrame(BWAPI::Game *Broodwar)
		{
			/****************************************************************************************************************
			*****************************************************************************************************************
			*****************************************************************************************************************
			*****************************************************************************************************************
			*******************************************ZEKE'S CODE BEGINS HERE***********************************************
			*****************************************************************************************************************
			*****************************************************************************************************************
			*****************************************************************************************************************
			****************************************************************************************************************/

			// PHASE 1 *****************************
			// *************************************
			//
			// DETERMINE WHERE OUR START LOCATION IS
			// SET PROPER COORDINATES
			//
			//
			// *************************************
			// *************************************
			if(!findPosition)
			{
				initialize(Broodwar);
				findPosition = true;
			}

			// PHASE 2 ***************************************
			// ***********************************************
			//
			// DIVIDE THE 6 ZERGLINGS INTO TWO GROUPS.
			// BOTH GROUPS INHERIT THE GROUPZERG LIST ELEMENTS
			//
			// ***********************************************
			// ***********************************************

			if(!grab)
			{
				for(std::set<Unit*>::const_iterator i = Broodwar->self()->getUnits().begin(); i != Broodwar->self()->getUnits().end(); i++)
				{
					if((*i)->getType() == UnitTypes::Zerg_Zergling)
						GroupZerg.insert((*i));

					zergHP = UnitTypes::Zerg_Zergling.maxHitPoints();
				}

				groupSize = GroupZerg.size();

				if(groupSize == 6)
					grab = true;
			}

			if(grab)
			{
				if(GroupZerg.size() == 6)
				{
					if(!groupPhase)
					{
						groupSize = GroupZerg.size();

						for(std::set<Unit*>::iterator i = GroupZerg.begin(); i != GroupZerg.end(); i++)
						{
							if(counter != (groupSize/2))
							{
								groupOne.insert((*i));
								counter++;
							}
						}

						groupTwo = GroupZerg - groupOne;
						groupPhase = true;

					}
				}
			}

			int sizeOne = groupOne.size();
			int sizeTwo = groupTwo.size();

			// PHASE 3 ****************************
			// ************************************
			//
			// FIGURE OUT WHAT MAP WE'RE ON
			// SEND ZERGLINGS TO PROPER COORDINATES
			//
			// ************************************
			// ************************************

			//groupGather

			if(Broodwar->enemy()->getRace() == Races::Zerg)
			{
				if(!zergAttack)
				{
					if(groupPhase)
					{
						for(std::set<Unit*>::const_iterator i = groupOne.begin(); i != groupOne.end(); i++)
						{
							(*i)->attack(firstGroupCoord[0]);
						}

						for(std::set<Unit*>::const_iterator i = groupTwo.begin(); i != groupTwo.end(); i++)
						{
							(*i)->attack(secondGroupCoord[0]);
						}
					}

					zergAttack = true;
				}
			}

			if(groupPhase)
			{
				if(!groupAttack)
				{
					// FOR GROUP ONE...
				
					for(std::set<Unit*>::const_iterator i = groupOne.begin(); i != groupOne.end(); i++)
					{
						for(int j = 1; j < size; j++)
						{
							if(firstGroupCoord[j] != Positions::None)
							{
								(*i)->move(Position(firstGroupCoord[j]), true);
							}
							else
							{
								j = j - 1;
								(*i)->attack(Position(firstGroupCoord[j]), true);
								break;
							}
						}
					}
				
					//FOR GROUP TWO
				
					for(std::set<Unit*>::const_iterator i = groupTwo.begin(); i != groupTwo.end(); i++)
					{
						
						for(int k = 1; k < size; k++)
						{
							if(secondGroupCoord[k] != Positions::None)
							{
								(*i)->move(Position(secondGroupCoord[k]), true);
							}
							else
							{
								k = k - 1;
								(*i)->attack(Position(secondGroupCoord[k]), true);
								break;
							}
						}
					}

				groupAttack = true;
				}
			} // end groupAttack

			/*for(std::set<Unit*>::const_iterator i = GroupZerg.begin(); i != GroupZerg.end(); i++)
			{
				for(std::set<Unit*>::const_iterator j = Broodwar->enemy()->getUnits().begin(); j != Broodwar->enemy()->getUnits().end(); j++)
				{
					if ((*j)->getType() == UnitTypes::Protoss_Zealot)
					{
						if((*j)->getTarget() == (*i) && (*i)->getHitPoints() != zergHP/2)
						{
							for(int k = 0; k < size; k++)
							{
								(*i)->move((firstGroupCoord[k]), true);
							}
						}
					}
				}
			}

			for(std::set<Unit*>::const_iterator i = GroupZerg.begin(); i != GroupZerg.end(); i++)
			{
				if((*i)->getHitPoints() == zergHP/2)
				{
					this->circleZerglings((*i));
				}
			}*/

		// END OF ATTACK PHASE
		//
		// *******************
		// *******************
			}

		void initialize(BWAPI::Game *Broodwar)
		{

			for(int i = 0; i < size; i++)
				{
					firstGroupCoord[i] = Positions::None;
					secondGroupCoord[i] = Positions::None;
				}
				// 2 Player Maps
				// Benzene
				// Bluestorm
				// Destination
				// heartbreakridge

			if(Broodwar->mapFileName() == "(2)Benzene.scx" )
			{
				// IF WE ARE BLUE, ATTACK RED
				if(Broodwar->self()->getStartLocation() != TilePosition(7, 96))
				{
					blah = Position(TilePosition(7, 96));

					firstGroupCoord[0] = Position(TilePosition(105, 31));
					firstGroupCoord[1] = Position(TilePosition(107, 10));
					firstGroupCoord[2] = Position(TilePosition(121, 11));

					secondGroupCoord[0] = Position(TilePosition(105, 31));
					secondGroupCoord[1] = Position(TilePosition(122, 21));
					secondGroupCoord[2] = Position(TilePosition(122, 17));
				
				}
				else
				{
					blah = Position(TilePosition(117, 13));
					

					firstGroupCoord[0] = Position(TilePosition(22, 81));
					firstGroupCoord[1] = Position(TilePosition(122, 21));
					firstGroupCoord[2] = Position(TilePosition(122, 17));

					secondGroupCoord[0] = Position(TilePosition(22, 81));
					secondGroupCoord[1] = Position(TilePosition(107,10));
					secondGroupCoord[2] = Position(TilePosition(121, 11));
				}
			}
			if(Broodwar->mapFileName() == "(2)Blue Storm.scx")
			{
				Broodwar->sendText("map is bluestorm");
				if(Broodwar->self()->getStartLocation() != TilePosition(8, 85))
				{
					blah = Position(TilePosition(8, 85));
					firstGroupCoord[0] = Position(TilePosition(25, 77));
					firstGroupCoord[1] = Position(TilePosition(14, 76));
					firstGroupCoord[2] = Position(TilePosition(6, 79));
					firstGroupCoord[3] = Position(TilePosition(6, 83));

					secondGroupCoord[0] = Position(TilePosition(25, 77));
					secondGroupCoord[1] = Position(TilePosition(24, 87));
					secondGroupCoord[2] = Position(TilePosition(13, 93));
					secondGroupCoord[3] = Position(TilePosition(6, 89));
				}
				else
				{
					blah = Position(TilePosition(116, 8));
					firstGroupCoord[0] = Position(TilePosition(102, 18));
					firstGroupCoord[1] = Position(TilePosition(104, 8));
					firstGroupCoord[2] = Position(TilePosition(112, 4));
					firstGroupCoord[3] = Position(TilePosition(121, 6));

					secondGroupCoord[0] = Position(TilePosition(102, 18));
					secondGroupCoord[1] = Position(TilePosition(111, 18));
					secondGroupCoord[2] = Position(TilePosition(120, 12));
				}
			}

			if(Broodwar->mapFileName() == "(2)Heartbreak Ridge.scx")
			{
				Broodwar->sendText("Yup");
				if(Broodwar->self()->getStartLocation() != TilePosition(117, 56))
				{
					blah = Position(TilePosition(117, 56));

					firstGroupCoord[0] = Position(TilePosition(113, 41));
					firstGroupCoord[1] = Position(TilePosition(110, 56));
					firstGroupCoord[2] = Position(TilePosition(116, 62));
					firstGroupCoord[3] = Position(TilePosition(122, 60));

					secondGroupCoord[0] = Position(TilePosition(113, 41));
					secondGroupCoord[1] = Position(TilePosition(120, 49));
					secondGroupCoord[2] = Position(TilePosition(122, 55));
					
				}
				else
				{
					blah = Position(TilePosition(7, 37));
					
					firstGroupCoord[0] = Position(TilePosition(14, 57));
					firstGroupCoord[1] = Position(TilePosition(5, 41));

					secondGroupCoord[0] = Position(TilePosition(14, 57));
					secondGroupCoord[1] = Position(TilePosition(18, 38));
					secondGroupCoord[2] = Position(TilePosition(12, 33));
					secondGroupCoord[3] = Position(TilePosition(5, 36));
				}

			}

			if(Broodwar->mapFileName() == "(2)Destination.scx")
			{

				// IF WE SPAWN AT BLUE, THEN COORDINATES ARE AS FOLLOWS...
				if(Broodwar->self()->getStartLocation() != TilePosition(31, 7))
				{
					blah = Position(TilePosition(31, 7));
					firstGroupCoord[0] = Position(TilePosition(57, 16));
					firstGroupCoord[1] = Position(TilePosition(34, 16));
					firstGroupCoord[2] = Position(TilePosition(29, 11));

					secondGroupCoord[0] = Position(TilePosition(57, 16));
					secondGroupCoord[1] = Position(TilePosition(44, 4));
					secondGroupCoord[2] = Position(TilePosition(37, 4));
					secondGroupCoord[3] = Position(TilePosition(29, 5));
				}
				// IF WE SPAWN AT RED, THEN COORDINATES ARE AS FOLLOWS...
				else
				{
					blah = Position(TilePosition(64, 118));
					firstGroupCoord[0] = Position(TilePosition(38, 112));
					firstGroupCoord[1] = Position(TilePosition(46, 120));
					firstGroupCoord[2] = Position(TilePosition(62, 125));
					firstGroupCoord[3] = Position(TilePosition(68, 123));

					secondGroupCoord[0] = Position(TilePosition(38, 112));
					secondGroupCoord[1] = Position(TilePosition(49, 112));
					secondGroupCoord[2] = Position(TilePosition(66, 110));
					secondGroupCoord[3] = Position(TilePosition(69, 116));
				}
			}
		}
};